#!/usr/bin/env node
import 'dotenv/config';
import fs from 'fs'; import path from 'path';
import fg from 'fast-glob'; import SFTPClient from 'ssh2-sftp-client';
const log=(...a)=>fs.appendFileSync('mcp-sftp.log', a.join(' ')+'\n');
let buf=''; process.stdin.setEncoding('utf8');
process.stdin.on('data',chunk=>{ buf+=chunk; let i; while((i=buf.indexOf('\n'))>=0){ const line=buf.slice(0,i).trim(); buf=buf.slice(i+1); if(!line) continue; try{ handle(JSON.parse(line)); }catch(e){ log('parse',e.message); } } });
function send(obj,id=null){ const msg={jsonrpc:'2.0'}; if(id!==null) msg.id=id; if(obj&&obj.error) msg.error=obj.error; else msg.result=obj??null; process.stdout.write(JSON.stringify(msg)+'\n'); }
const tools=[
  {name:'sftp_list',description:'List remote dir',inputSchema:{type:'object',properties:{path:{type:'string'}},required:['path']}},
  {name:'sftp_put',description:'Upload local file',inputSchema:{type:'object',properties:{local:{type:'string'},remote:{type:'string'}},required:['local','remote']}},
  {name:'sftp_delete',description:'Delete remote file',inputSchema:{type:'object',properties:{remote:{type:'string'}},required:['remote']}},
  {name:'sftp_mkdirp',description:'Create remote dir',inputSchema:{type:'object',properties:{remoteDir:{type:'string'}},required:['remoteDir']}},
  {name:'sftp_sync',description:'Sync local→remote',inputSchema:{type:'object',properties:{localDir:{type:'string'},remoteDir:{type:'string'},ignore:{type:'string'}},required:['localDir','remoteDir']}},
  {name:'deploy_default',description:'Sync using .env defaults',inputSchema:{type:'object',properties:{}}}
];
const env=(k,d)=>process.env[k]??d;
function cfg(){ const c={host:env('SFTP_HOST','localhost'),port:Number(env('SFTP_PORT','22')),username:env('SFTP_USER',''),password:process.env.SFTP_PASS};
  const k=process.env.SFTP_KEY_PATH; if(k&&fs.existsSync(k)){ c.password=undefined; c.privateKey=fs.readFileSync(k); if(process.env.SFTP_KEY_PASSPHRASE) c.passphrase=process.env.SFTP_KEY_PASSPHRASE; } return c; }
async function withSftp(fn){ const c=new SFTPClient(); await c.connect(cfg()); try{ return await fn(c); } finally{ try{ await c.end(); }catch{} } }
async function mkdirp(c,dir){ const parts=dir.replace(/\\/g,'/').split('/').filter(Boolean); let cur=dir.startsWith('/')?'/':''; for(const p of parts){ cur=path.posix.join(cur,p); try{ await c.stat(cur); }catch{ try{ await c.mkdir(cur,true);}catch{} } } }
async function list({path:pathIn}){ return await withSftp(async c=>({ entries: await c.list(pathIn) })); }
async function put({local,remote}){ return await withSftp(async c=>{ await mkdirp(c,path.posix.dirname(remote)); await c.fastPut(local,remote); return {ok:true,remote}; }); }
async function del({remote}){ return await withSftp(async c=>{ await c.delete(remote,false); return {ok:true}; }); }
async function mk({remoteDir}){ return await withSftp(async c=>{ await mkdirp(c,remoteDir); return {ok:true}; }); }
function parseIgnore(s){ return (s||'').split(',').map(x=>x.trim()).filter(Boolean); }
async function sync({localDir,remoteDir,ignore}){
  const base=path.resolve(localDir||env('LOCAL_DIR','.')); const rbase=(remoteDir||env('REMOTE_DIR','/')).replace(/\\/g,'/');
  const patt=await fg(['**/*'],{cwd:base,dot:true,ignore:parseIgnore(ignore||env('IGNORE',''))});
  return await withSftp(async c=>{ let uploaded=0,skipped=0,errors=0;
    for(const rel of patt){ const abs=path.join(base,rel); if(fs.lstatSync(abs).isDirectory()) continue; const r=path.posix.join(rbase, rel.split(path.sep).join('/'));
      try{ await mkdirp(c,path.posix.dirname(r)); let putFile=true;
        try{ const st=await c.stat(r); const l=fs.statSync(abs); if(st.size===l.size && Math.abs(new Date(st.modifyTime).getTime()/1000 - Math.floor(l.mtimeMs/1000))<2) putFile=false; }catch{}
        if(putFile){ await c.fastPut(abs,r); uploaded++; } else skipped++;
      }catch(e){ errors++; log('sync', rel, e.message); }
    }
    return {ok:true,uploaded,skipped,errors,remoteDir:rbase};
  });
}
async function deployDefault(){ return await sync({}); }
async function handle(msg){ const {id=null,method,params={}}=msg;
  if(method==='initialize') return send({capabilities:{tools:{}}},id);
  if(method==='tools/list') return send({tools},id);
  if(method==='tools/call'){ const {name,arguments:args}=params; try{
      let res=null; if(name==='sftp_list') res=await list(args);
      else if(name==='sftp_put') res=await put(args);
      else if(name==='sftp_delete') res=await del(args);
      else if(name==='sftp_mkdirp') res=await mk(args);
      else if(name==='sftp_sync') res=await sync(args);
      else if(name==='deploy_default') res=await deployDefault();
      else throw new Error('unknown tool '+name);
      return send({content:[{type:'text',text:JSON.stringify(res)}]},id);
    }catch(e){ return send({error:{code:-32000,message:e.message}},id); } }
  return send({error:{code:-32601,message:'Method not found'}},id);
}
process.stdin.resume();
