# 🎸 RIBW - Vollständiges Benutzerhandbuch

## 📖 Inhaltsverzeichnis

1. [Einführung](#einführung)
2. [Installation & Erste Schritte](#installation--erste-schritte)
3. [Grundfunktionen](#grundfunktionen)
4. [Erweiterte Funktionen](#erweiterte-funktionen)
5. [DAW-Funktionen](#daw-funktionen)
6. [Live-Performance](#live-performance)
7. [Fehlerbehebung](#fehlerbehebung)
8. [Referenz](#referenz)

---

## 🚀 Einführung

### Was ist RIBW?

RIBW (Ribbon Web) ist ein umfassendes, webbasiertes Digital Audio Workstation (DAW) System, das speziell für Gitarristen und Live-Performance entwickelt wurde. Es kombiniert professionelle Gitarren-Tools mit einer vollwertigen DAW in einer einzigen HTML-Datei.

### Hauptmerkmale

- **🎵 Gitarren-Tools**: Akkord-Transposer, Griffbilder, TAB-Generator
- **🎛️ Professionelle DAW**: Waveform-Editor, Effekte, Multi-Track
- **🌐 Browser-basiert**: Funktioniert auf allen Geräten
- **💾 Offline-fähig**: Nach dem ersten Laden vollständig offline nutzbar
- **🎯 Live-Performance**: Optimiert für Live-Einsatz

---

## 📥 Installation & Erste Schritte

### Systemanforderungen

- **Browser**: Chrome 80+, Firefox 75+, Safari 13+, Edge 80+
- **Audio**: Web Audio API Unterstützung
- **Speicher**: Mindestens 100MB freier Speicher
- **Internet**: Nur für den ersten Download der Bibliotheken

### Installation

1. **Datei herunterladen**
   ```bash
   # Repository klonen oder ZIP herunterladen
   git clone [repository-url]
   cd RIBW/Secondedition
   ```

2. **Im Browser öffnen**
   ```bash
   # Doppelklick auf "Gitarre Html.html"
   # Oder im Browser öffnen
   ```

3. **Audio aktivieren**
   - Klicke auf "🔊 Audio aktivieren"
   - Erlaube Audio-Zugriff wenn gefragt wird
   - Warte auf "✅ Audio erfolgreich aktiviert"

### Erste Konfiguration

1. **Tuning auswählen**
   - Standard: "E Standard (E A D G B E)"
   - Alternativen: Drop D, DADGAD, Open G

2. **Capo einstellen**
   - Standard: 0 (kein Capo)
   - Bereich: 0-12 Bünde

3. **Tempo einstellen**
   - Standard: 120 BPM
   - Bereich: 40-240 BPM

---

## 🎵 Grundfunktionen

### Akkorde eingeben

#### Einfache Eingabe
```
C G Am F
```
- **Leerzeichen** trennen Akkorde
- **Automatische Erkennung** von Dur/Moll
- **Unterstützte Qualitäten**: maj, min, 7, maj7, m7, dim, aug

#### Erweiterte Syntax
```
C#maj7/G  Dm7  F#dim  Bb7
```
- **#/b**: Kreuz/B-Vorzeichen
- **maj/min**: Dur/Moll Qualität
- **7, maj7, m7**: Septakkorde
- **/G**: Bass-Note (Slash-Chords)

### Akkorde abspielen

1. **Akkorde eingeben** im Hauptfeld
2. **Tuning auswählen** aus dem Dropdown
3. **Capo einstellen** falls benötigt
4. **▶️ Abspielen** klicken
5. **⏸ Pause** für Unterbrechung
6. **⏹ Stopp** für Neustart

### Griffbilder anzeigen

- **Automatische Generierung** aller Akkorde
- **Mehrere Voicings** pro Akkord
- **Offene und Barré-Griffe**
- **Optimierte Fingersätze**

---

## 🎛️ Erweiterte Funktionen

### VexFlow Notation

#### Musiknotation
- **Notenschlüssel**: Violinschlüssel
- **Rhythmus**: Viertelnoten (standard)
- **Tonart**: Automatisch aus Akkorden
- **Layout**: Automatische Formatierung

#### Tabulatur
- **6-saitige Gitarre** Standard
- **Fingersätze** mit Bund-Nummern
- **Offene Saiten** als "0" dargestellt
- **Nicht gespielte Saiten** als "x"

### Export-Funktionen

#### PDF-Export
1. **Export-Button** klicken
2. **PDF-Format** wählen
3. **Inhalt auswählen**: Griffbilder, TAB, Notation
4. **Datei herunterladen**

#### MIDI-Export
1. **MIDI-Button** klicken
2. **Spuren auswählen**: Gitarre, Bass, Drums
3. **Tempo einstellen**
4. **MIDI-Datei herunterladen**

---

## 🎛️ DAW-Funktionen

### DAW öffnen

1. **DAW-Button** unten rechts klicken
2. **Vollständiges Studio-Interface** öffnet sich
3. **Waveform-Editor** wird angezeigt
4. **Effekt-Kette** ist verfügbar

### Audio importieren

#### Drag & Drop
1. **Audio-Datei** auf den Waveform-Bereich ziehen
2. **Datei loslassen**
3. **Automatisches Laden** und Decoding
4. **Waveform wird angezeigt**

#### Datei-Button
1. **"Audio laden"** Button klicken
2. **Datei auswählen** (WAV, MP3, OGG)
3. **Datei öffnen**
4. **Waveform wird angezeigt**

### Waveform bearbeiten

#### Auswahl
- **Linksklick** + ziehen für Auswahl
- **Rechtsklick** für Kontext-Menü
- **Doppelklick** für Cursor-Position

#### Kontext-Menü
- **An Cursor teilen**: Segment an aktueller Position teilen
- **Ausschneiden**: Auswahl entfernen und in Zwischenablage
- **Kopieren**: Auswahl in Zwischenablage kopieren
- **Einfügen**: An Cursor-Position einfügen
- **Löschen**: Auswahl entfernen
- **Alles markieren**: Komplettes Audio markieren

### Effekte anwenden

#### 3-Band EQ
- **Low**: 120Hz Tiefpass-Filter
- **Mid**: 1000Hz Peaking-Filter
- **High**: 6000Hz Hochpass-Filter
- **Bereich**: -12dB bis +12dB

#### Stereo-Pan
- **Bereich**: -1 (links) bis +1 (rechts)
- **0**: Zentriert
- **Feinschritt**: 0.01

#### Gain
- **Bereich**: 0.0 bis 2.0
- **Standard**: 1.0 (0dB)
- **Feinschritt**: 0.01

#### Delay
- **Zeit**: 0.1s bis 2.0s
- **Feedback**: 0% bis 90%
- **Mix**: 0% bis 100%

### Export

#### WAV-Mixdown
1. **"Mixdown WAV"** Button klicken
2. **Offline-Rendering** startet
3. **Alle Effekte** werden angewendet
4. **WAV-Datei** wird heruntergeladen

---

## 🎯 Live-Performance

### Performance-Optimierung

#### Hardware-Erkennung
- **Automatische Erkennung** der verfügbaren Hardware
- **Performance-Anpassung** basierend auf CPU/GPU
- **Memory-Optimierung** für Stabilität
- **Audio-Latenz** Minimierung

#### Echtzeit-Performance
- **Niedrige Latenz**: <10ms für Audio
- **Stabile Framerate**: 60fps für UI
- **Memory-Management**: Automatische Bereinigung
- **Background-Processing**: Nicht-blockierende Operationen

### Live-Workflow

#### Vorbereitung
1. **Alle Akkorde** vorher eingeben
2. **Tempo einstellen** für die Band
3. **Tuning überprüfen**
4. **Audio-System testen**

#### Während der Performance
1. **Akkorde abspielen** mit Play-Button
2. **Tempo anpassen** falls nötig
3. **Capo ändern** für andere Tonarten
4. **Effekte live** anpassen

#### Nach der Performance
1. **Projekt speichern** für späteren Gebrauch
2. **Audio exportieren** falls gewünscht
3. **Einstellungen zurücksetzen** für nächste Session

---

## 🔧 Fehlerbehebung

### Häufige Probleme

#### Audio funktioniert nicht
**Symptom**: Kein Ton, Fehlermeldung "Audio nicht verfügbar"

**Lösung**:
1. **Browser aktualisieren** auf neueste Version
2. **Audio-Zugriff erlauben** wenn gefragt wird
3. **"🔊 Audio aktivieren"** Button klicken
4. **Seite neu laden** falls nötig

#### Langsame Performance
**Symptom**: Verzögerungen, Ruckler, hohe CPU-Last

**Lösung**:
1. **Andere Programme schließen** die CPU verbrauchen
2. **Browser-Tabs schließen** die nicht benötigt werden
3. **Hardware-Beschleunigung** in Browser aktivieren
4. **Audio-Buffer-Größe** reduzieren

#### DAW öffnet sich nicht
**Symptom**: DAW-Button funktioniert nicht, kein Interface

**Lösung**:
1. **Seite neu laden**
2. **JavaScript aktiviert** überprüfen
3. **Browser-Konsole** auf Fehler prüfen
4. **Cache leeren** und neu laden

### Erweiterte Fehlerbehebung

#### Browser-Konsole prüfen
1. **F12** drücken für Developer Tools
2. **Console-Tab** öffnen
3. **Fehlermeldungen** lesen
4. **Rote Fehler** identifizieren

#### System-Informationen sammeln
1. **Browser-Version** notieren
2. **Betriebssystem** dokumentieren
3. **Audio-Hardware** überprüfen
4. **Verfügbarer Speicher** prüfen

---

## 📚 Referenz

### Tastatur-Shortcuts

#### Allgemein
- **Leertaste**: Play/Pause
- **Escape**: Alle Dropdowns schließen
- **Strg+S**: Projekt speichern
- **Strg+O**: Projekt öffnen

#### DAW-Modus
- **Leertaste**: Play/Pause
- **Strg+C**: Auswahl kopieren
- **Strg+X**: Auswahl ausschneiden
- **Strg+V**: An Cursor einfügen
- **Strg+A**: Alles markieren

### Akkord-Qualitäten

#### Dur-Akkorde
```
C, D, E, F, G, A, B
Cmaj, Dmaj, Emaj, Fmaj, Gmaj, Amaj, Bmaj
```

#### Moll-Akkorde
```
Cm, Dm, Em, Fm, Gm, Am, Bm
Cmin, Dmin, Emin, Fmin, Gmin, Amin, Bmin
```

#### Septakkorde
```
C7, D7, E7, F7, G7, A7, B7
Cmaj7, Dmaj7, Emaj7, Fmaj7, Gmaj7, Amaj7, Bmaj7
Cm7, Dm7, Em7, Fm7, Gm7, Am7, Bm7
```

#### Erweiterte Akkorde
```
Cdim, Ddim, Edim, Fdim, Gdim, Adim, Bdim
Caug, Daug, Eaug, Faug, Gaug, Aaug, Baug
Csus2, Dsus2, Esus2, Fsus2, Gsus2, Asus2, Bsus2
Csus4, Dsus4, Esus4, Fsus4, Gsus4, Asus4, Bsus4
```

### Tuning-Referenz

#### Standard-Tunings
- **E Standard**: E2 A2 D3 G3 B3 E4
- **Drop D**: D2 A2 D3 G3 B3 E4
- **DADGAD**: D2 A2 D3 G3 A3 D4
- **Open G**: D2 G2 D3 G3 B3 D4

#### Capo-Effekte
- **Capo 1**: Alle Töne +1 Halbton
- **Capo 2**: Alle Töne +2 Halbtöne
- **Capo 3**: Alle Töne +3 Halbtöne
- **Capo 4**: Alle Töne +4 Halbtöne

### Effekt-Parameter

#### EQ-Einstellungen
- **Low Shelf**: 120Hz, Q=1
- **Mid Peaking**: 1000Hz, Q=1
- **High Shelf**: 6000Hz, Q=1

#### Delay-Einstellungen
- **Feedback**: 0% bis 90%
- **Mix**: 0% bis 100%
- **Zeit**: 0.1s bis 2.0s

#### Reverb-Einstellungen
- **Decay**: 0.1s bis 10.0s
- **Mix**: 0% bis 100%
- **Pre-delay**: 0ms bis 100ms

---

## 🆘 Support & Hilfe

### Hilfe bekommen

#### Dokumentation
- **Dieses Handbuch** vollständig durchlesen
- **Code-Kommentare** in der HTML-Datei studieren
- **Beispiel-Projekte** analysieren

#### Community
- **GitHub Issues** für Bug-Reports
- **Diskussions-Forum** für Fragen
- **Beispiel-Projekte** teilen

#### Technischer Support
- **Browser-Konsole** für Fehler-Details
- **System-Informationen** sammeln
- **Reproduzierbare Schritte** dokumentieren

### Weiterentwicklung

#### Neue Features vorschlagen
1. **Feature-Request** auf GitHub erstellen
2. **Use-Case** detailliert beschreiben
3. **Beispiel-Implementierung** falls möglich
4. **Community-Feedback** sammeln

#### Code beitragen
1. **Fork** des Repositories erstellen
2. **Feature-Branch** für Änderungen
3. **Tests** für neue Funktionalität
4. **Pull Request** mit Beschreibung

---

## 📝 Changelog

### Version 2.0 - Dezember 2024
- **Vollständige DAW-Integration** hinzugefügt
- **Live-Test-Suite** implementiert
- **Performance-Optimierungen** für Live-Einsatz
- **Umfassende Dokumentation** in 3 Sprachen
- **Hardware-Erkennung** und automatische Optimierung

### Version 1.5 - November 2024
- **VexFlow-Integration** für professionelle Notation
- **Erweiterte Akkord-Qualitäten** hinzugefügt
- **Export-Funktionen** verbessert
- **UI/UX-Optimierungen** implementiert

### Version 1.0 - Oktober 2024
- **Grundlegende Gitarren-Tools** implementiert
- **Akkord-Transposer** mit Real-Time-Playback
- **Griffbild-Generator** mit mehreren Voicings
- **ASCII-TAB-Generator** für schnelle Notation

---

**🎵 Viel Erfolg mit RIBW! 🎵**

*Bei Fragen oder Problemen: Dokumentation lesen, Community konsultieren oder Issue erstellen.*

---

*Letzte Aktualisierung: Dezember 2024*
*Version: 2.0 - Vollständiges System*
*Sprache: Deutsch*
